/*
 * Echo serveris
 * 
 * Author: Kstutis Mizara
 * Description: Gauna kliento praneim ir isiunia atgal
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <winsock2.h>

int main(int argc, char *argv []){
    WSADATA wsaData;
    if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0)
    {
       return -1;                        
    }
    unsigned int port;
    int l_socket; // socket'as skirtas prisijungim laukimui
    int c_socket; // prisijungusio kliento socket'as

    struct sockaddr_in servaddr; // Serverio adreso struktra
    struct sockaddr_in clientaddr; // Prisijungusio kliento adreso struktra
    int clientaddrlen;

    int s_len;
    int r_len;
    char buffer[1024];
    
    if (argc != 2){
        printf("USAGE: %s <port>\n", argv[0]);
        exit(1);
    }

    port = atoi(argv[1]);

    if ((port < 1) && (port > 65535)){
        printf("ERROR #1: invalid port specified.\n");
        exit(1);
    }

    /*
     * Sukuriamas serverio socket'as
     */
    if ((l_socket = socket(AF_INET, SOCK_STREAM,0))< 0){
        fprintf(stderr,"ERROR #2: cannot create listening socket.\n");
        exit(1);
    }
    
    /*
     * Ivaloma ir upildoma serverio adreso struktra
     */
    memset(&servaddr,0, sizeof(servaddr));
    servaddr.sin_family = AF_INET; // nurodomas protokolas (IP)

    /*
     * Nurodomas IP adresas, kuriuo bus laukiama klient, iuo atveju visi 
     * esami sistemos IP adresai (visi interfeis'ai)
     */
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY); 
    servaddr.sin_port = htons(port); // nurodomas portas
    
    /*
     * Serverio adresas susiejamas su socket'u
     */
    if (bind (l_socket, (struct sockaddr *)&servaddr,sizeof(servaddr))<0){
        fprintf(stderr,"ERROR #3: bind listening socket.\n");
        exit(1);
    }

    /*
     * Nurodoma, kad socket'u l_socket bus laukiama klient prisijungimo,
     * eilje ne daugiau kaip 5 aptarnavimo laukiantys klientai
     */
    if (listen(l_socket, 5) <0){
        fprintf(stderr,"ERROR #4: error in listen().\n");
        exit(1);
    }

    for(;;){
        /*
         * Ivalomas buferis ir kliento adreso struktra
         */
        memset(&clientaddr,0, sizeof(clientaddr));
        memset(&buffer,0,sizeof(buffer));

        /*
         * Laukiama klient prisijungim
         */
        if ((c_socket = accept(l_socket,
            (struct sockaddr*)&clientaddr,&clientaddrlen))<0){
            fprintf(stderr,"ERROR #5: error occured accepting connection.\n");
            exit(1);
        }

        /*
         * Sulaukus kliento prisijungimo skaitomi kliento siuniami duomenys
         */
        do {
        s_len = recv(c_socket,buffer,sizeof(buffer),0);

        /*
         * Klientui isiuniami gauti duomenys
         */
        r_len = send(c_socket,buffer,s_len,0);

        if (s_len == -1){
        printf("CLIENT PISSED OFF!! :)\n");
        } else {
        printf("IP: %s Sent: %d Received: %d\n",inet_ntoa(clientaddr.sin_addr),
            s_len, r_len
        );
        };
        } while(s_len > 0);
        /*
         * Klientas atjungiamas
         */
        close(c_socket);
    }

     return 0;
}
